/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package concurrentCollections;

import java.util.Queue;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Consumer implements Runnable{
    
    Queue q;//The queue we will be processing.
    
    public Consumer(Queue q){
        //set the queue that we will be working from.
        this.q=q;
    }
    
    //Process the numbers on the queue by printing them.
    @Override
    public void run(){
        while (true){//Consumers are typically always running in the background
            //Get the next object off the queue
            Object o = q.poll();
            //If there is something to process go ahead and do it.
            if (o!=null){
                System.out.println("Next on queue: "+o
                                   +" consumed by "+Thread.currentThread().getName());
            }
            //Have a break for a bit
            try{
                Thread.sleep(10);
            } catch (InterruptedException ex) {
                System.out.println(Thread.currentThread().getName()+" was interrupted.");
            }
        }
    }
}
